/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.cim.provider.pi;

import com.ibm.hsc.cim.provider.pi.PIHscCimObjUtils;
import com.ibm.hsc.cim.provider.rs6k.CimomWrapper;
import com.ibm.hsc.common.exceptions.PIHscServerException;
import com.ibm.hsc.common.util.HSCLogUtils;
import com.ibm.hsc.common.util.Trace;
import com.ibm.hsc.objmgr.cec.OmCecMgr;
import com.ibm.hsc.objmgr.nvram.PIHMCSaveArea;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.snia.wbem.cim.CIMClass;
import org.snia.wbem.cim.CIMException;
import org.snia.wbem.cim.CIMInstance;
import org.snia.wbem.cim.CIMObjectPath;
import org.snia.wbem.cim.CIMValue;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.client.CIMOMHandle;

public class PISystemProfUpdater {
    private CIMOMHandle cimHandle = null;
    private CIMObjectPath sysProfObjPath;
    private CIMInstance sysProfInst;
    private String cecName = null;
    private String sysProfId = null;

    public PISystemProfUpdater(CIMOMHandle cIMOMHandle, CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) {
        this.cimHandle = cIMOMHandle;
        this.sysProfObjPath = cIMObjectPath;
        this.sysProfInst = cIMInstance;
        try {
            this.cecName = (String)cIMInstance.getProperty("SystemName").getValue().getValue();
            this.sysProfId = (String)cIMInstance.getProperty("Name").getValue().getValue();
            if (3 <= Trace.LEVEL) {
                Trace.trace("apsphscD", "PISystemProfUpdater constructor - cecName = " + this.cecName + ", sysProfId = " + this.sysProfId);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            HSCLogUtils.serverLog(throwable, HSCLogUtils._SysProfileClassLogInfo);
        }
    }

    public void update() throws PIHscServerException, CIMException {
        if (1 <= Trace.LEVEL) {
            Trace.trace("apsphscT", "PISystemProfUpdater: update ->");
        }
        System.out.println("In sysProfile update!!");
        if (2 <= Trace.LEVEL) {
            Trace.trace("apsphscF", "cecName: " + this.cecName);
            Trace.trace("apsphscF", "sysProfId: " + this.sysProfId);
        }
        OmCecMgr omCecMgr = OmCecMgr.getCecMgr(this.cecName);
        PIHMCSaveArea pIHMCSaveArea = PIHMCSaveArea.getPIHMCSaveAreaInstance(this.cecName);
        Hashtable hashtable = pIHMCSaveArea.getSysProfile(Integer.parseInt(this.sysProfId));
        if (hashtable == null) {
            CIMObjectPath cIMObjectPath = new CIMObjectPath("IBMHSC_ComputerSystem", "root/ibmhscS1_0");
            cIMObjectPath.addKey("CreationClassName", new CIMValue((Object)"IBMHSC_ComputerSystem"));
            cIMObjectPath.addKey("Name", new CIMValue((Object)this.cecName));
            PIHscCimObjUtils.deleteSystemProfile(this.cimHandle, this.sysProfInst, this.sysProfObjPath, cIMObjectPath);
            if (2 <= Trace.LEVEL) {
                Trace.trace("apsphscF", "++++++++ sys profile ID " + this.sysProfId + " has been deleted!");
            }
            System.out.println("++++++++ sys profile ID " + this.sysProfId + " deleted!");
            try {
                omCecMgr.getIndMgr().sendIndication(2, this.sysProfInst, null);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                HSCLogUtils.serverLog(throwable, HSCLogUtils._CECClassLogInfo);
            }
            return;
        }
        boolean bl = false;
        String string = (String)hashtable.get("UserDefinedName");
        CIMInstance cIMInstance = CimomWrapper.getInstance(this.cimHandle, this.sysProfObjPath, this.cimHandle.getClass(this.sysProfObjPath, false), false);
        CIMInstance cIMInstance2 = cIMInstance.filterProperties(null, true, true);
        if (CimomWrapper.setPropertyString(cIMInstance2, "UserDefinedName", string)) {
            if (2 <= Trace.LEVEL) {
                Trace.trace("apsphscF", "+++++++++ UserDefinedName has been changed!");
            }
            System.out.println("+++++++++ UserDefinedName has been changed!");
            bl = true;
        }
        if (bl) {
            CimomWrapper.setInstance(this.cimHandle, this.sysProfObjPath, cIMInstance2);
            try {
                omCecMgr.getIndMgr().sendIndication(4, cIMInstance2, cIMInstance);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                HSCLogUtils.serverLog(throwable, HSCLogUtils._CECClassLogInfo);
            }
        }
        boolean bl2 = this.updateInSysProfiles(hashtable, this.sysProfObjPath);
        if (1 <= Trace.LEVEL) {
            Trace.trace("apsphscT", "<- PISystemProfUpdater: update");
        }
    }

    public boolean updateInSysProfiles(Hashtable hashtable, CIMObjectPath cIMObjectPath) throws PIHscServerException, CIMException {
        Object object;
        Integer n;
        Integer n2;
        Enumeration<Object> enumeration;
        Integer n3;
        Integer n4;
        System.out.println("+++++++++ updateInSysProfiles");
        if (1 <= Trace.LEVEL) {
            Trace.trace("apsphscT", "PISystemProfUpdater: updateInSysProfiles ->");
        }
        boolean bl = false;
        Vector vector = (Vector)hashtable.get("ProfileList");
        CIMObjectPath cIMObjectPath2 = new CIMObjectPath("IBMHSC_InSysProfile", "root/ibmhscS1_0");
        Enumeration enumeration2 = null;
        if (vector == null) {
            if (2 <= Trace.LEVEL) {
                Trace.trace("apsphscF", "No LPAR profiles for sys profile in NVRAM - deleting associations!");
            }
            enumeration2 = CimomWrapper.referenceNames(this.cimHandle, cIMObjectPath2, cIMObjectPath, null).elements();
            while (enumeration2.hasMoreElements()) {
                CIMObjectPath cIMObjectPath3 = (CIMObjectPath)enumeration2.nextElement();
                CIMInstance cIMInstance = CimomWrapper.getInstance(this.cimHandle, cIMObjectPath3, new CIMClass("IBMHSC_InSysProfile"), false);
                CimomWrapper.deleteInstance(this.cimHandle, cIMObjectPath3);
            }
            bl = true;
            return bl;
        }
        Hashtable<Integer, Integer> hashtable2 = new Hashtable<Integer, Integer>();
        Hashtable<Integer, Integer> hashtable3 = new Hashtable<Integer, Integer>();
        Vector vector2 = (Vector)hashtable.get("PartitionList");
        for (int i = 0; i < vector.size(); ++i) {
            n4 = (Integer)vector.elementAt(i);
            int n5 = ((UnsignedInt16)vector2.elementAt(i)).intValue();
            n3 = new Integer(n5);
            hashtable2.put(n4, n3);
            hashtable3.put(n4, new Integer(i));
        }
        Vector vector3 = CimomWrapper.associators(this.cimHandle, cIMObjectPath2, cIMObjectPath, "IBMHSC_LparProfile", "GroupComponent", "PartComponent", true, true, null);
        n4 = null;
        CIMObjectPath cIMObjectPath4 = null;
        n3 = null;
        Integer n6 = null;
        if (vector3 != null && !vector3.isEmpty()) {
            enumeration = vector3.elements();
            while (enumeration.hasMoreElements()) {
                n4 = (CIMInstance)enumeration.nextElement();
                n2 = new CIMObjectPath(n4.getClassName(), n4.getKeyValuePairs());
                n2.setNameSpace("root/ibmhscS1_0");
                n = Integer.valueOf((String)n4.getProperty("SettingID").getValue().getValue());
                object = (Integer)hashtable2.get(n);
                cIMObjectPath4 = new CIMObjectPath("IBMHSC_InSysProfile");
                cIMObjectPath4.addKey("GroupComponent", new CIMValue((Object)cIMObjectPath));
                cIMObjectPath4.addKey("PartComponent", new CIMValue((Object)n2));
                cIMObjectPath4.setNameSpace("root/ibmhscS1_0");
                if (object == null) {
                    try {
                        n3 = CimomWrapper.getInstance(this.cimHandle, cIMObjectPath4, new CIMClass("IBMHSC_InSysProfile"), false);
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                        n3 = null;
                    }
                    if (n3 == null) continue;
                    if (2 <= Trace.LEVEL) {
                        Trace.trace("apsphscF", "Not in save area - deleting association: " + cIMObjectPath4);
                    }
                    System.out.println("+++++++++ deleting association: " + cIMObjectPath4);
                    CimomWrapper.deleteInstance(this.cimHandle, cIMObjectPath4);
                    bl = true;
                    continue;
                }
                if (2 <= Trace.LEVEL) {
                    Trace.trace("apsphscF", "++++++++ lpar profile is in system profile: " + n);
                }
                System.out.println("++++++++ lpar profile is in system profile: " + n);
                try {
                    n3 = CimomWrapper.getInstance(this.cimHandle, cIMObjectPath4, new CIMClass("IBMHSC_InSysProfile"), false);
                }
                catch (Throwable throwable) {
                    n3 = null;
                }
                if (n3 != null) {
                    n6 = (Integer)hashtable3.get(n);
                    boolean bl2 = false;
                    if (CimomWrapper.setProperty((CIMInstance)n3, "ActivateOrder", new UnsignedInt16((int)n6.shortValue()))) {
                        if (2 <= Trace.LEVEL) {
                            Trace.trace("apsphscF", "ActivateOrder was changed to: " + n6);
                        }
                        System.out.println("ActivateOrder was changed to: " + n6);
                        bl2 = true;
                    }
                    if (bl2) {
                        CimomWrapper.setInstance(this.cimHandle, cIMObjectPath4, (CIMInstance)n3);
                        bl = true;
                    }
                }
                hashtable2.remove(n);
            }
        }
        enumeration = hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            n2 = (Integer)enumeration.nextElement();
            n = (Integer)hashtable2.get(n2);
            if (2 <= Trace.LEVEL) {
                Trace.trace("apsphscF", "++++++++ creating new InSysProfile instance for new profile: " + n2);
            }
            System.out.println("++++++++ creating new InSysProfile instance for new profile: " + n2);
            object = n + "*" + this.cecName;
            CIMObjectPath cIMObjectPath5 = new CIMObjectPath("IBMHSC_LparProfile", "root/ibmhscS1_0");
            cIMObjectPath5.addKey("PartitionCreationClassName", new CIMValue((Object)"IBMHSC_Partition"));
            cIMObjectPath5.addKey("PartitionName", new CIMValue(object));
            cIMObjectPath5.addKey("SettingID", new CIMValue((Object)n2.toString()));
            cIMObjectPath5.setNameSpace("root/ibmhscS1_0");
            CIMObjectPath cIMObjectPath6 = new CIMObjectPath("IBMHSC_InSysProfile", "root/ibmhscS1_0");
            n3 = this.cimHandle.getClass(cIMObjectPath6, false).newInstance();
            n3.setProperty("GroupComponent", new CIMValue((Object)cIMObjectPath));
            n3.setProperty("PartComponent", new CIMValue((Object)cIMObjectPath5));
            n6 = (Integer)hashtable3.get(n2);
            if (2 <= Trace.LEVEL) {
                Trace.trace("apsphscF", "activate order: " + n6);
            }
            System.out.println("order: " + n6);
            n3.setProperty("ActivateOrder", new CIMValue((Object)new UnsignedInt16(n6.intValue())));
            cIMObjectPath4 = new CIMObjectPath(n3.getClassName(), n3.getKeyValuePairs());
            cIMObjectPath4.setNameSpace("root/ibmhscS1_0");
            CIMObjectPath cIMObjectPath7 = CimomWrapper.createInstance(this.cimHandle, cIMObjectPath4, (CIMInstance)n3);
            bl = true;
            if (1 > Trace.LEVEL) continue;
            Trace.trace("apsphscT", "new inSysProfile association created: " + cIMObjectPath7);
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace("apsphscT", "<- PISystemProfUpdater: updateInSysProfiles");
        }
        return bl;
    }
}

